/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching.ColorCalculators;

import BryceImages.ColorCalculators.RayMarching.BryceMath;
import BryceImages.Rendering.ColorCalculator;
import java.awt.Color;
import java.awt.Dimension;

public class ccShamrock
extends ColorCalculator {
    double rhoInc;

    public ccShamrock(Dimension tempDim) {
        super(tempDim);
        this.antiAliasing = 3;
    }

    @Override
    public Color getColor(double x, double y) {
        int factor = BryceMath.min(this.room_width, this.room_height);
        double xinc = (x -= (double)(this.room_width / 2)) / (double)factor;
        double yinc = (y -= (double)(this.room_height / 2)) / (double)factor;
        double zinc = 0.7;
        this.rhoInc = 1.0;
        double temp = BryceMath.distance(0.0, 0.0, 0.0, xinc, yinc, zinc);
        xinc /= temp;
        yinc /= temp;
        zinc /= temp;
        x = 0.0;
        y = 0.0;
        double z = -6.0;
        double prescision = 1.0E-6;
        int bound = 6;
        while (!(BryceMath.abs(x) > (double)bound || BryceMath.abs(y) > (double)bound || BryceMath.abs(z) > (double)bound)) {
            this.rhoInc = 1000.0;
            this.DE(x, y, z);
            if (this.rhoInc < prescision) {
                double e = 1.0E-11;
                double dx = this.DE(x + e, y, z) - this.DE(x - e, y, z);
                double dy = this.DE(x, y + e, z) - this.DE(x, y - e, z);
                double dz = this.DE(x, y, z + e) - this.DE(x, y, z - e);
                double dist = BryceMath.distance(0.0, 0.0, 0.0, dx, dy, dz);
                temp = 16.666666666666668;
                return ccShamrock.Color_hsv(134.0, 100.0, 50.0 + (temp * (dx /= dist) + temp * (dy /= dist) + temp * (dz /= dist)));
            }
            x += xinc * this.rhoInc;
            y += yinc * this.rhoInc;
            z += zinc * this.rhoInc;
        }
        return ccShamrock.Color_hsv(134.0, 0.0, 0.0, 0.0);
    }

    public double DE(double x, double y, double z) {
        double angle;
        if (z > 0.0) {
            this.rhoInc = 1000.0;
            return 1000.0;
        }
        this.rhoInc = 0.1;
        this.sphere(x, y, z, 0.0, 0.0, -0.9, 1.0);
        if (z < -1.2) {
            angle = BryceMath.lineAngle(x + 2.0, BryceMath.abs(y), 0.0, 0.0);
            this.sphere(x, y, z, -2.0, 0.0, 0.0, angle / 180.0);
            angle = BryceMath.lineAngle(-(x - 2.0), BryceMath.abs(y), 0.0, 0.0);
            this.sphere(x, y, z, 2.0, 0.0, 0.0, angle / 180.0);
            angle = BryceMath.lineAngle(y + 2.0, BryceMath.abs(x), 0.0, 0.0);
            this.sphere(y, x, z, -2.0, 0.0, 0.0, angle / 180.0);
            angle = BryceMath.lineAngle(-y + 2.0, BryceMath.abs(x), 0.0, 0.0);
            this.sphere(y, x, z, 2.0, 0.0, 0.0, angle / 180.0);
        }
        if ((angle = BryceMath.lineAngle(x, y, 3.0, 3.0)) > 140.0 && angle < 270.0) {
            this.torus(x, y, z, 3.0, 3.0, 0.0, 3.0, 0.1);
        }
        return this.rhoInc;
    }

    public void torus(double x, double y, double z, double tx, double ty, double tz, double radius, double thickness) {
        double angle = BryceMath.lineAngle(x, y, tx, ty);
        angle = BryceMath.degToRad(angle);
        this.rhoInc = BryceMath.min(BryceMath.distance(x, y, z, radius * BryceMath.cos(angle) + tx, -radius * BryceMath.sin(angle) + ty, tz) - thickness, this.rhoInc);
    }

    public void sphere(double x, double y, double z, double sx, double sy, double sz, double radius) {
        double dist = BryceMath.distance(x, y, z, sx, sy, sz) - radius;
        this.rhoInc = BryceMath.min(this.rhoInc, dist);
    }
}

